#version 130
#extension GL_EXT_gpu_shader4 : enable
//Trip to Samrakand MosqueMod01.fsh by  asiJa  

//https://www.shadertoy.com/view/fdV3R1
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// This shader should be a tutorial how to animate simple fractal in order to explore possibilities use it for music visualization
// everywere is used iTime can we can put filtered (e.g. smoothed) music-waveform to make it react on music

// It is slightly modified version of Grinning Fractal   https://www.shadertoy.com/view/Msf3WS
// The modifications are
// 1] addded comment to make it easier for new-commers to understand complex-numbered fractal shaders in general
// 2] added time-dependnet pahse shit into color-function in order to vary shading/coloring with time
// 3] added rotation into fractal iteration formula with time-varying agle so that it produce more broad span of patterns 


// Number of iterations for fractal transform  (more iterations produce more complicated fractal)
//#define Niter 10
//#define Niter 20
//#define Niter 40
#define Niter 60
//#define Niter 80


vec2 cmul(vec2 a, vec2 b){  // Complex multiplication  https://en.wikipedia.org/wiki/Complex_number#Multiplication_and_square
    return vec2( a.x*b.x - a.y*b.y,  
                 a.x*b.y + a.y*b.x);
}

vec2 rotate( vec2 z, float angle){
    vec2 cs = vec2(cos(angle),sin(angle));   // unitary complex number encode rotation 
	return cmul(z, cs);                      // multiplication of z by unitary complex number rotate it in complex plane
}

// This is some comlex-number mathematical equation of transformation
vec2 FractalTransform_GrinningF( vec2 z, vec2 C ){
    // I have now idea why this particual transformation procduce beautifull results
    //z = cmul(z,z);
    z = vec2(z.x,abs(z.y));             // abs(z.y) works like mirror => it looks like Kaleidoscope
    //vec2  a = vec2(z.x,    z.y );     // withouit abs() it is not so nice
	float b = atan(z.y, z.x);
	if(b > 0.0) b -= 6.283185307179586;
    z = vec2(log(dot(z,z))*0.5,b);      // Not sure why this particular transform looks good
    z += C;                             // ANIMATION 1] Add the constant shift - we use it for animation
    return z;
}

float fractal(vec2 z0, vec2 C) {	
	vec2 z = z0;      // starting pixel
	float mean = 0.0;
    // iteraive transform of the pixel
    // z = F(F(F(F(F(z)))))
    // every iteration branche it => produce fractal with many sub-domains
    float angle = sin(iTime*0.03)*0.15;  // ANIMATION 2] time dependnet rotation angle
    vec2  crot  = vec2(cos(angle),sin(angle)); // just to save some performance we store rotation as unitary complex number
 	for(int i = 0;i < Niter; i++) {
        z=cmul(z,crot);               // ANIMATION 2] rotate the compolex number
        z = FractalTransform_GrinningF( z, C );
        //vec2 d =z1-z; z=z1; mean+=length(d);
        mean+=length(z); // acumulate mean distance of transformed pixel from origin at each iteration
	}
    return mean/float(Niter);
    //vec3 color = colorFunc( mean );
    //return color;
}

// This generate color of pixel from calculated mean distance
vec3 colorFunc( float mean ){
	float ci = 1.0 - log2(.5*log2(mean/1.0));
    float t  = iTime * 0.5;   //  ANIMATION 3] time dependnet phase shift of color
    return vec3(
        0.5 + 0.5*cos( ci*6.0 + 0.0 + t),   // Red   - each color channel have different animation speed
        0.5 + 0.5*cos( ci*6.0 + 0.4 + t),   // Green
        0.5 + 0.5*cos( ci*6.0 + 0.8 + t*0.9)    // Blue
    );
    //return cos( vec3(ci)*6.0 + vec3(0.0,0.4,0.7) )*0.5 + 0.5;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    //  map pixel position (fragCoord)  to interval -1.0 .. 1.0
	vec2 uv = fragCoord.xy - iResolution.xy*.5; 
	//uv /= 0.25*iResolution.x;
    uv /= 0.4*iResolution.x;
    
    // rotate camera with time
    uv = rotate( uv, sin(iTime*0.02)*2.7 );
	
    // generate constant C for Julia set from sin,cos of current time to make fractal Animate with time
    float juliax = sin(iTime * 0.5    ) * 0.02 + 0.2;
	float juliay = cos(iTime * 0.13) * 0.04 + 5.7;
     // or you ma also try to set fixed constant parameter 
    vec2 C = vec2(juliax, juliay);
    //C = vec2(0.2,5.7-0.1);        
	
    float meanDist = fractal( uv, C );       // evaluate fractal 
    vec3  col      = colorFunc( meanDist );  // map the fractal mean-distance into color
    fragColor = vec4( col ,1.0);             // output to screen

return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.